/*
#pragma GCC optimize("Ofast,unroll-loops")
#pragma GCC target("avx2,tune=native")
*/

#include <iostream>
#include <vector>
#include <algorithm>
using namespace std;
typedef int64_t ll;
typedef uint64_t ull;

ll gcd(ll x, ll y) {
    while (y) {
        x %= y;
        swap(x, y);
    }
    return x;
}

int main() {
    ios_base::sync_with_stdio(false);
    cin.tie(nullptr);
    ll t;
    cin >> t;
    while (t--) {
        ll x, y;
        cin >> x >> y;
        vector<ll> d;
        d.reserve(100);
        ll num = y - x;
        if (num == 0) {
            cout << 0 << "\n";
            continue;
        }
        for (ll i = 1; i * i <= num; ++i) {
            if (num % i == 0) {
                d.push_back(i);
                if (i != num / i) {
                    d.push_back(num / i);
                }
            }
        }
        sort(d.begin(), d.end());
        ll best_dist = 1e18;
        for (ll del : d) {
            ll n = num / del + 1;
            ll k = y - del * n;
            if (k < 0)
                continue;
            if (k == x - del && k < best_dist) {
                best_dist = k;
            }
        }
        cout << best_dist << "\n";
    }
}
